/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


/*

*/

var STBLayoutButtonNext			= Object.create(STBModule.prototype);
	STBLayoutButtonNext.name	= "STBLayoutButtonNext";


STBLayoutButtonNext.initPlugin = function() {

	if (STBLayoutScroller.isActive()) {
		return true;
	}

	//create elements
	var elements = jQuery(".button-scroll-next:not(.__done_btn)");

	if (elements.length){
		elements.each(function() {
			var el = jQuery(this),
				btn = jQuery("<span />");

			btn.addClass("button-scroll-next-act");

			el.append(btn);
		});

		elements.addClass("__done_btn");
	}

	
	jQuery(document).on("click", ".button-scroll-next-act", function() {

		var button	= jQuery(this),
			section = button.parent(),
			loc		= section.offset(),
			height	= section.outerHeight(),
			body	= jQuery("body");

		if (jQuery(".page-wrapper").length) {
			var cont = jQuery(".page-wrapper");
		} else {
			var cont = jQuery("html, body");
		}

		//if top intro use some special treatment
		if (section.hasClass("topintro") && (body.attr('data-topintro-menu') === 'true')) {
			//get the wrapper margin top:
			height += parseInt(jQuery("body > .wrapper").css("margin-top"));
		}

		
		cont.stop().animate(
			{
				scrollTop: ( loc.top + height)
			}
		);

	});
}

STBLayoutButtonNext.scrollHash = function() {
	$("a[href*=#]").click(function(e) {

		var path	= window.location.pathname,
			addr	= jQuery(this).attr("href"),
			parts	= addr.split("#");


		var url		= addr.slice(0, addr.indexOf("#")),
			hash	= addr.slice(addr.indexOf("#"));

		if (url == path) {
			e.preventDefault();

			var el  = jQuery(hash),
				obj = jQuery(this);

			if (el.length > 0) {

				if (jQuery(".page-wrapper").length) {
					var cont = jQuery(".page-wrapper");
				} else {
					var cont = jQuery("html, body");
				}

				pos = el.offset().top;

				if (jQuery("header").hasClass("sticky")){
					console.log(pos);
					pos -= jQuery("body > .wrapper").height();
					
					console.log(jQuery("body > .wrapper").height());
					console.log(pos);
				}

				cont.stop().animate(
					{
						scrollTop: ( pos )
					}
				);

				if (obj.closest(".widget-links").length > 0){
					obj.parent().siblings(".active").removeClass("active");
					obj.parent().addClass("active");
				}
			}
		}
	});  


}


STBLayoutButtonNext.runOnReady = function() {
	STBLayoutButtonNext.scrollHash();
	STBLayoutButtonNext.initPlugin();
}

STBLayoutButtonNext.runOnLoad = function() {
}

STBLayoutButtonNext.runOnContentUpdate = function() {
	STBLayoutButtonNext.initPlugin();
}

STBLayoutButtonNext.runOnResize = function() {

}

site.registerModule(STBLayoutButtonNext);